/********************************************************************
 FileName:     	HardwareProfile - PICDEM FSUSB K50.h
 Dependencies:  See INCLUDES section
 Processor:     PIC18 USB Microcontrollers
 Hardware:      PICDEM FSUSB populated with PIC18F45K50
 Compiler:      Microchip C18
 Company:       Microchip Technology, Inc.

 Software License Agreement:

 The software supplied herewith by Microchip Technology Incorporated
 (the "Company") for its PIC� Microcontroller is intended and
 supplied to you, the Company's customer, for use solely and
 exclusively on Microchip PIC Microcontroller products. The
 software is owned by the Company and/or its supplier, and is
 protected under applicable copyright laws. All rights are reserved.
 Any use in violation of the foregoing restrictions may subject the
 user to criminal sanctions under applicable laws, as well as to
 civil liability for the breach of the terms and conditions of this
 license.

 THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
 WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.

********************************************************************
 File Description:

 Change History:
  Rev   Date         Description
  2.9f  06/25/2012   Initial release
********************************************************************/

#ifndef HARDWARE_PROFILE_PICDEM_FSUSB_K50_H
#define HARDWARE_PROFILE_PICDEM_FSUSB_K50_H

    /*******************************************************************/
    /******** USB stack hardware selection options *********************/
    /*******************************************************************/
    //This section is the set of definitions required by the MCHPFSUSB
    //  framework.  These definitions tell the firmware what mode it is
    //  running in, and where it can find the results to some information
    //  that the stack needs.
    //These definitions are required by every application developed with
    //  this revision of the MCHPFSUSB framework.  Please review each
    //  option carefully and determine which options are desired/required
    //  for your application.

    //The PICDEM FS USB Demo Board platform supports the USE_SELF_POWER_SENSE_IO
    //and USE_USB_BUS_SENSE_IO features.  Uncomment the below line(s) if
    //it is desireable to use one or both of the features.
    //#define USE_SELF_POWER_SENSE_IO
    #define tris_self_power     TRISAbits.TRISA2    // Input
    #if defined(USE_SELF_POWER_SENSE_IO)
    #define self_power          PORTAbits.RA2
    #else
    #define self_power          1
    #endif

    //#define USE_USB_BUS_SENSE_IO
    #define tris_usb_bus_sense  TRISAbits.TRISA1    // Input
    #if defined(USE_USB_BUS_SENSE_IO)
    #define USB_BUS_SENSE       PORTAbits.RA1
    #else
    #define USB_BUS_SENSE       1
    #endif


    //Uncomment the following line to make the output HEX of this  
    //  project work with the MCHPUSB Bootloader    
    //#define PROGRAMMABLE_WITH_USB_MCHPUSB_BOOTLOADER
	
    //Uncomment the following line to make the output HEX of this 
    //  project work with the HID Bootloader
    #define PROGRAMMABLE_WITH_USB_HID_BOOTLOADER		

    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/
    /******** Application specific definitions *************************/
    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/

    /** Board definition ***********************************************/
    //These defintions will tell the main() function which board is
    //  currently selected.  This will allow the application to add
    //  the correct configuration bits as wells use the correct
    //  initialization functions for the board.  These defitions are only
    //  required in the stack provided demos.  They are not required in
    //  final application design.
    #define DEMO_BOARD PICDEM_FS_USB_K50
    #define PICDEM_FS_USB_K50
    #define PIC18F45K50_FAMILY
//    #define CLOCK_FREQ 48000000


    /** LED ************************************************************/
#if defined(HARDKERNEL_PIC18F45K50)
    #define mInitAllLEDs()      LATC &= 0xFB; TRISC &= 0xFB;
    #define mInitLCDPort()      {TRISAbits.TRISA1=0; LATAbits.LATA1=1; LATD &= 0x0F; TRISD &= 0x0F; LATE &= 0xF8; TRISE &= 0xF8; LATA &= 0x0F; TRISA &= 0x0F;}
#else
    #define mInitAllLEDs()      LATD &= 0xF0; TRISD &= 0xF0;
#endif
    
#if defined(HARDKERNEL_PIC18F45K50)
    #define mLED_1              LATCbits.LATC2
#else
    #define mLED_1              LATDbits.LATD0
#endif

    #define mLED_2              LATDbits.LATD1
    #define mLED_3              LATDbits.LATD2
    #define mLED_4              LATDbits.LATD3
///
    #define mLCD_D4             LATDbits.LATD4
    #define mLCD_D5             LATDbits.LATD5
    #define mLCD_D6             LATDbits.LATD6
    #define mLCD_D7             LATDbits.LATD7
//    #define mLCD_DATA(x)        {   LATD &= 0x0F; LATD |= (x & 0xF0); LATA &= 0x0F; LATA |= ((x << 4) & 0xF0); }
    #define mLCD_DATA(x)        {   LATD &= 0x0F; LATD |= (x & 0xF0); }
    #define mLCD_E              LATEbits.LATE0
    #define mLCD_RW             LATEbits.LATE1
    #define mLCD_RS             LATEbits.LATE2
///
    #define mGetLED_1()         mLED_1
    #define mGetLED_2()         mLED_2
    #define mGetLED_3()         mLED_3
    #define mGetLED_4()         mLED_4

    #define mLED_1_On()         mLED_1 = 1;
    #define mLED_2_On()         mLED_2 = 1;
    #define mLED_3_On()         mLED_3 = 1;
    #define mLED_4_On()         mLED_4 = 1;
    
    #define mLED_1_Off()        mLED_1 = 0;
    #define mLED_2_Off()        mLED_2 = 0;
    #define mLED_3_Off()        mLED_3 = 0;
    #define mLED_4_Off()        mLED_4 = 0;
    
    #define mLED_1_Toggle()     mLED_1 = !mLED_1;
    #define mLED_2_Toggle()     mLED_2 = !mLED_2;
    #define mLED_3_Toggle()     mLED_3 = !mLED_3;
    #define mLED_4_Toggle()     mLED_4 = !mLED_4;
    
    /** SWITCH *********************************************************/
#if defined(HARDKERNEL_PIC18F45K50)
    #define mInitAllSwitches()  TRISDbits.TRISD2=1;TRISDbits.TRISD3=1;TRISBbits.TRISB5=1;
#else
    #define mInitAllSwitches()  TRISBbits.TRISB4=1;TRISBbits.TRISB5=1;
#endif

#if defined(HARDKERNEL_PIC18F45K50)
    #define mInitSwitch2()      TRISDbits.TRISD3=1;
#else
    #define mInitSwitch2()      TRISBbits.TRISB4=1;
#endif

    #define mInitSwitch3()      TRISBbits.TRISB5=1;

    #define sw2                 PORTBbits.RB4

#if defined(HARDKERNEL_PIC18F45K50)
    #define sw3                 PORTDbits.RD3
#else
    #define sw3                 PORTBbits.RB5
#endif
    
    /** POT ************************************************************/
    #define mInitPOT()          {TRISAbits.TRISA0=1;ANSELAbits.ANSA0=1;ADCON1=0;ADCON2=0xBE;ADCON0=0x01;}

    #define mInitDetect()       {TRISCbits.TRISC0=1;TRISBbits.TRISB4=1;}
   
    #define mInitUSART()		{TRISCbits.TRISC6=0;TRISCbits.TRISC7=1;}

    /** I/O pin definitions ********************************************/
    #define INPUT_PIN 1
    #define OUTPUT_PIN 0
#endif  //HARDWARE_PROFILE_PICDEM_FSUSB_K50_H
